Imports System.Reflection

Module MainMod
    ' Extraire toutes les mthodes de la classe Foo.
    Public Sub ListMethods(ByVal f As Foo)
        Console.WriteLine("***** Mthodes de la classe Foo *****")
        Dim t As Type = f.GetType()
        Dim mi As MethodInfo() = t.GetMethods()
        Dim m As MethodInfo

        ' Parcourir le tableau methodinfo et afficher les noms.
        For Each m In mi
            Console.WriteLine("Mthode : {0}", m.Name)
        Next
        Console.WriteLine("*************************")
        Console.WriteLine()
    End Sub

    'Extraire tous les champs de la classe Foo.
    Public Sub ListFields(ByVal f As Foo)

        Console.WriteLine("***** Champs de la classe Foo *****")

        Dim t As Type = f.GetType()
        Dim fi As FieldInfo() = t.GetFields()
        Dim field As FieldInfo
        For Each field In fi
            Console.WriteLine("Champ: {0}", field.Name)
        Next
        Console.WriteLine("*************************")
        Console.WriteLine()
    End Sub

    ' Extraire quelques statistiques intressantes pour la classe Foo.
    Public Sub ListVariousStats(ByVal f As Foo)

        Console.WriteLine("***** Statistiques varies sur la classe Foo *****")
        Dim t As Type = f.GetType()

        Console.WriteLine("Le nom complet est: {0}", t.FullName)
        Console.WriteLine("La base est: {0}", t.BaseType)
        Console.WriteLine("Est-ce une classe abstraite? {0}", t.IsAbstract)
        Console.WriteLine("Est-ce un objet COM? {0}", t.IsCOMObject)
        Console.WriteLine("Est-ce un objet de type sealed? {0}", t.IsSealed)
        Console.WriteLine("Est-ce une classe? {0}", t.IsClass)

        Console.WriteLine("***********************************")
        Console.WriteLine()
    End Sub

    'Rassembler toutes les proprits.
    Public Sub ListProps(ByVal f As Foo)

        Console.WriteLine("***** Proprits de la classe Foo *****")

        Dim t As Type = f.GetType()
        Dim pi As PropertyInfo() = t.GetProperties()
        Dim prop As PropertyInfo
        For Each prop In pi
            Console.WriteLine("Proprit : {0}", prop.Name)
        Next
        Console.WriteLine("*****************************")
        Console.WriteLine()
    End Sub

    ' Rcuprer toutes les interfaces prises en charge par la classe Foo.
    Public Sub ListInterfaces(ByVal f As Foo)

        Console.WriteLine("***** Interfaces de la classe Foo *****")

        Dim t As Type = f.GetType()
        Dim ifaces As Type() = t.GetInterfaces()
        Dim i As Type
        For Each i In ifaces
            Console.WriteLine("Interface : {0}", i.Name)
        Next
        Console.WriteLine("*****************************")
        Console.WriteLine()
    End Sub

    Sub Main()
        ' Construire un objet Foo et l'examiner de prs !
        Dim theFoo As New Foo()
        Dim t As Type = theFoo.GetType()
        Console.WriteLine("Mon pre est : {0}", t.BaseType)

        ' Rcuprer un objet Type utilisant la mthode partage Type.GetType().
        Dim t2 As Type
        t2 = Type.GetType("System.String")
        Console.WriteLine("Mon pre est : {0}", t2.BaseType)

        ' Utiliser la mthode VB.NET GetType().
        Dim t3 As Type
        t3 = GetType(Foo)
        Console.WriteLine("Mon nom complet est {0}", t3.FullName)
        Console.WriteLine()

        ListVariousStats(theFoo)
        ListMethods(theFoo)
        ListFields(theFoo)
        ListProps(theFoo)
        ListInterfaces(theFoo)
    End Sub

End Module
